// Realtime Send Matrix View ImageDlg.cpp : implementation file
//

#include "stdafx.h"
#include "Realtime Send Matrix View Image.h"
#include "Realtime Send Matrix View ImageDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


/////////////////////////////////////////////////////////////////////////////
// CRealtimeSendMatrixViewImageDlg dialog

CRealtimeSendMatrixViewImageDlg::CRealtimeSendMatrixViewImageDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CRealtimeSendMatrixViewImageDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CRealtimeSendMatrixViewImageDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CRealtimeSendMatrixViewImageDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CRealtimeSendMatrixViewImageDlg)
	DDX_Control(pDX, IDC_COMBO_DELAY, m_comboDelay);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CRealtimeSendMatrixViewImageDlg, CDialog)
	//{{AFX_MSG_MAP(CRealtimeSendMatrixViewImageDlg)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_WM_TIMER()
	ON_BN_CLICKED(IDC_BUTTON_STARTSTOP, OnButtonStartstop)
	ON_BN_CLICKED(IDC_BUTTON_SENDONCE, OnButtonSendonce)
	ON_BN_CLICKED(IDC_BUTTON_SETPLOTCOLOR, OnButtonSetplotcolor)
	ON_BN_CLICKED(IDC_BUTTON_INIT, OnButtonInit)
	ON_BN_CLICKED(IDC_BUTTON_SETMATRIX, OnButtonSetmatrix)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CRealtimeSendMatrixViewImageDlg message handlers

BOOL CRealtimeSendMatrixViewImageDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	// TODO: Add extra initialization here
	m_comboDelay.SetCurSel(0);
	m_nSendCount = 0;
	m_nAuto = 0;
	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CRealtimeSendMatrixViewImageDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		//CAboutDlg dlgAbout;
		//dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CRealtimeSendMatrixViewImageDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CRealtimeSendMatrixViewImageDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

// function to enable or disable GUI controls
void CRealtimeSendMatrixViewImageDlg::enableControls(bool bConnected)
{
	GetDlgItem(IDC_BUTTON_SENDONCE)->EnableWindow(bConnected);
	GetDlgItem(IDC_BUTTON_STARTSTOP)->EnableWindow(bConnected);
	GetDlgItem(IDC_BUTTON_SETPLOTCOLOR)->EnableWindow(bConnected);
	GetDlgItem(IDC_BUTTON_SETMATRIX)->EnableWindow(bConnected);

	GetDlgItem(IDC_BUTTON_INIT)->EnableWindow(!bConnected);
}

// generate color
// we are filling the matrix with r + c from 0
// so the range of values in the matrix is from 0 to this value
int CRealtimeSendMatrixViewImageDlg::getRGB(int red, int green, int blue)
{
	int nColor = 0x000000FF & red;
	nColor += (0x000000FF & green) << 8;
	nColor += (0x000000FF & blue) << 16;
	return nColor;
}

// setup a colormap
bool CRealtimeSendMatrixViewImageDlg::setZColormap(ColorMapPtr map)
{
	// initiliaze the colormap to view the image
	double zLevel[NUM_COLORS + 1];
	int	zColor[NUM_COLORS];

	for ( int ii = 0; ii < NUM_COLORS + 1; ii++ )
	{
		zLevel[ii] = ii * getMaxValue() / (NUM_COLORS - 1);
	}
	// generate color ramp from Blue to Red, no Green
	for ( int jj = 0; jj < NUM_COLORS; jj++ )
	{
		int red = jj * 255 / (NUM_COLORS - 1);
		int blue = (NUM_COLORS - 1 - jj) * 255 / (NUM_COLORS - 1);
		zColor[jj] = getRGB(red, 0, blue);
	}
	VARIANT vtLevel, vtColor;

	VariantInit(&vtLevel);
	vtLevel.vt = VT_R8 | VT_ARRAY; 	//set it as array of double type
	SAFEARRAYBOUND bounds[1];
	bounds[0].cElements = NUM_COLORS + 1; //number of items in array
	bounds[0].lLbound = 0; //lower bound of array
	vtLevel.parray = SafeArrayCreate(VT_R8, 1, bounds);	 //create an array of double type
	vtLevel.parray->pvData = zLevel; // assign data to VARIANT

	VariantInit(&vtColor);
	vtColor.vt = VT_I4 | VT_ARRAY; 	 //set it as array of int type
	bounds[0].cElements = NUM_COLORS;	  //number of items in array
	bounds[0].lLbound = 0;	 //lower bound of array
	vtColor.parray = SafeArrayCreate(VT_I4, 1, bounds);	 //create an array of int type
	vtColor.parray->pvData = zColor; // assign color data to VARIANT

	return map->SetLevels(vtLevel, vtColor);
}
//connect to Origin and prepare objects
bool CRealtimeSendMatrixViewImageDlg::initOrigin()
{
	CoInitialize(NULL);

	//m_pIOApp = new Origin::Application();
	this->m_pOrigin.CreateInstance(__uuidof(ApplicationSI));
	m_pOrigin->PutVisible(Origin::MAINWND_SHOW_BRING_TO_FRONT);

	DWORD nVisible = 2;
	m_pOrigin->CreatePage( _variant_t((long)Origin::OPT_MATRIX), vtMissing, vtMissing, _variant_t((long)nVisible));
	
	m_pMatrixPage = m_pOrigin->GetActivePage();
	m_pMatrixSheet = m_pMatrixPage->GetLayers()->GetItem(_variant_t(long(0)));
	m_pMatrixSheet->Activate();

	if( m_pMatrixSheet )
	{
		m_pMatrixSheet->PutCols(NUM_COLS);
		m_pMatrixSheet->PutRows(NUM_ROWS);
		m_pMatrixObject = m_pMatrixSheet->GetMatrixObjects()->GetItem(_variant_t(long(0))); //get first matrixobject
		if ( NULL == m_pMatrixObject )
			m_pMatrixObject =m_pMatrixSheet->GetMatrixObjects()->Add();
		m_pMatrixObject->Activate();
		m_pMatrixObject->DataFormat = Origin::DF_USHORT;
        //set to view matrix as image
		m_pMatrixObject->ViewImage = true;
	}
	enableControls(true);
	return true;
}
//send data to Origin
bool CRealtimeSendMatrixViewImageDlg::sendData()
{
	if( m_pMatrixObject )
	{
		USHORT MAX = getMaxValue();

		COleSafeArray csarr;
		DWORD bounds[] = {NUM_ROWS, NUM_COLS};
		csarr.Create(VT_UI2, 2, bounds);
		long index[2];

		for( int ii = 0; ii < NUM_ROWS; ii++ )
		{
			for( int jj = 0; jj < NUM_COLS; jj++ )
			{
				USHORT usData = ii + jj;
				if ( (m_nSendCount % 2 == 0) && ii > NUM_ROWS / 2 ) // every other time will flip the matrix
				{
					usData = MAX - usData; // flip only the bottom half to allow some stationary image remove "&& ii > NUM_ROWS / 2" will flip whole matrix
				}
				index[0] = ii;
				index[1] = jj;
				csarr.PutElement(index, &usData);
			}
		}
		m_nSendCount++;

		VARIANT vtRow, vtCol;
		vtRow.vt = VT_I4;
		vtRow.intVal = 0;
		vtCol.vt = VT_I4;
		vtCol.intVal = 0;
		m_pMatrixObject->SetData(csarr, vtRow, vtCol);
        //for now, need to use LabTalk to specify the Z range of the image to be drawn, Z1 and Z2 are LabTalk variables for the given
        //matrix object to control the Z range to showing the image. Execute for matrixObject is not supported so use matrix sheet
        //is good enough to affect the active MatrixObject
		CString strCMD;
		strCMD.Format("%s%d", "Z1=0;Z2=", MAX);
		m_pMatrixSheet->Execute(_bstr_t(strCMD));
		CString str;
		str.Format("%d %s", m_nSendCount, "sending...");
		GetDlgItem(IDC_EDIT_MESSAGE)->SetWindowText(str);
	}
	return true;
}

USHORT CRealtimeSendMatrixViewImageDlg::getMaxValue()
{
	return (NUM_COLS + NUM_ROWS - 2);
}

void CRealtimeSendMatrixViewImageDlg::OnTimer(UINT nIDEvent) 
{
	// TODO: Add your message handler code here and/or call default
	if ( nIDEvent == m_nAuto )
	{
		sendData();
	}

	CDialog::OnTimer(nIDEvent);
}

void CRealtimeSendMatrixViewImageDlg::OnButtonStartstop() 
{
	// TODO: Add your control notification handler code here
	if ( m_nAuto )
	{
		KillTimer(m_nAuto);
		GetDlgItem(IDC_BUTTON_STARTSTOP)->SetWindowText("Start");
		m_nAuto = 0;

	}
	else
	{
		m_nAuto = 1;
		GetDlgItem(IDC_BUTTON_STARTSTOP)->SetWindowText("Stop");
		CString strDelay;
		m_comboDelay.GetWindowText(strDelay);
		char* p = strDelay.GetBuffer(strDelay.GetLength());
		UINT nElapse;
		sscanf(p, "%d", &nElapse);
		SetTimer(m_nAuto, nElapse, NULL);
		strDelay.ReleaseBuffer();
	}
}

void CRealtimeSendMatrixViewImageDlg::OnButtonSendonce() 
{
	// TODO: Add your control notification handler code here
	sendData();
}

void CRealtimeSendMatrixViewImageDlg::OnButtonSetplotcolor() 
{
	// TODO: Add your control notification handler code here
	if ( NULL == m_pDataPlot )
    {
        GraphLayerPtr glay = m_pOrigin->FindGraphLayer("Graph1");
        if ( glay != NULL )
        {
			VARIANT vItem;
			VariantInit(&vItem);
			vItem.vt = VT_I4;
			vItem.lVal = 0;
			try
			{
				m_pDataPlot = glay->GetDataPlots()->GetItem(vItem);
			}
			catch (CException* e)
			{
				m_pDataPlot = NULL;
			}
			catch(...)
			{
				m_pDataPlot = NULL;
			}
        }
    }
    if ( m_pDataPlot != NULL )
    {
        if ( setZColormap(m_pDataPlot->GetColorMap()) )
            GetDlgItem(IDC_EDIT_MESSAGE)->SetWindowText("colormap done!");
        else
            GetDlgItem(IDC_EDIT_MESSAGE)->SetWindowText("set colormap failed");
    }
    else
        GetDlgItem(IDC_EDIT_MESSAGE)->SetWindowText("m_pDataPlot is null, please plot the matrix as an image plot or contour plot first.");	
}

void CRealtimeSendMatrixViewImageDlg::OnButtonInit() 
{
	// TODO: Add your control notification handler code here
	initOrigin();
}

void CRealtimeSendMatrixViewImageDlg::OnButtonSetmatrix() 
{
	// TODO: Add your control notification handler code here
    if ( m_pMatrixObject != NULL )
    {
        if ( setZColormap(m_pMatrixObject->GetColorMap()) )
            GetDlgItem(IDC_EDIT_MESSAGE)->SetWindowText("colormap done!");
        else
            GetDlgItem(IDC_EDIT_MESSAGE)->SetWindowText("set colormap failed");
    }
    else
        GetDlgItem(IDC_EDIT_MESSAGE)->SetWindowText("m_pMatrixObject is null");
}
